% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{format_pvalue}
\alias{format_pvalue}
\title{Format P-values for Publication}
\usage{
format_pvalue(x, digits = 3, threshold = 0.001, html = FALSE)
}
\arguments{
\item{x}{A numeric vector of p-values.}

\item{digits}{Integer. Number of decimal places for rounding. Default is 3.}

\item{threshold}{Numeric. P-values below this threshold are displayed as
"< threshold". Default is 0.001.}

\item{html}{Logical. If \code{TRUE}, uses HTML formatting for the less-than symbol.
Default is \code{FALSE}.}
}
\value{
A character vector of formatted p-values.
}
\description{
Formats p-values according to common publication standards, with configurable
thresholds and decimal places.
}
\details{
The function applies the following rules:
\itemize{
\item P-values below \code{threshold} are formatted as "< 0.001" (or HTML equivalent)
\item P-values >= \code{threshold} are rounded to \code{digits} decimal places
\item \code{NA} values are preserved as \code{NA_character_}
\item Values > 1 or < 0 return \code{NA_character_} with a warning
}
}
\examples{
# Basic usage
format_pvalue(0.0234)
#> "0.023"

format_pvalue(0.00005)
#> "< 0.001"

# Vector input
pvals <- c(0.5, 0.05, 0.001, 0.0001, NA)
format_pvalue(pvals)
#> "0.500" "0.050" "0.001" "< 0.001" NA

# Custom threshold
format_pvalue(0.005, threshold = 0.01)
#> "< 0.01"

# HTML output
format_pvalue(0.0001, html = TRUE)
#> "&lt; 0.001"

}
