## -----------------------------------------------------------------------------
library(rD3plot)
data("crannetworkdata")
links <- crannetworkdata$links
nodes <- crannetworkdata$nodes

## ----message=FALSE, warning=FALSE---------------------------------------------
net <- network_rd3(links=links, nodes=nodes, lcolor="Type", size="downloadsyear",
  info="info", color="downloads", dir="CRANnetwork")
plot(net)

## ----echo=FALSE---------------------------------------------------------------
knitr::include_graphics("CRANnetwork.png")

## ----message=FALSE, warning=FALSE---------------------------------------------
# It is necessary the creation of a list of networks
nets <- list()
# Each network, delimited by time, will be a frame
for(t in (min(links$Year):max(links$Year))){
    sublinks <- links[links$Year<=t,]
    nets[[paste0("year_",t)]] <- network_rd3(links=sublinks, nodes=nodes, lcolor="Type",
      size="downloads", info="info")
}
# Join this networks in a evolutive network with the `evolNetwork_rd3` function
net <- evolNetwork_rd3(nets, dir="CRANnetworkEvol")
plot(net)

## ----echo=FALSE---------------------------------------------------------------
knitr::include_graphics("CRANnetworkEvol.png")

