% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{rowsNA}
\alias{rowsNA}
\title{Frequency of Multiple Sets of Missing Values by Row}
\usage{
rowsNA(data, vrb.nm.list, prop = FALSE, ov = FALSE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm.list}{list where each element is a character vector of colnames
in \code{data} specifying the variables for that set of columns. The names
of \code{vrb.nm.list} will be the colnames of the return object.}

\item{prop}{logical vector of length 1 specifying whether the frequency of
missing values should be returned as a proportion (TRUE) or a count
(FALSE).}

\item{ov}{logical vector of length 1 specifying whether the frequency of
observed values (TRUE) should be returned rather than the frequency of
missing values (FALSE).}
}
\value{
data.frame with the frequency of missing values (or observed values
  if \code{ov} = TRUE) for each set of variables. The names are specified by
  \code{names(vrb.nm.list)}; if \code{vrb.nm.list} does not have any names,
  then the first element from \code{vrb.nm.list[[i]]} is used.
}
\description{
\code{rowsNA} computes the frequency of missing values for multiple sets of
columns from a data.frame. The arguments \code{prop} and \code{ov} allow the
user to specify if they want to sum or mean the missing values as well as
compute the frequency of observed values rather than missing values. This
function is essentially a vectorized version of \code{rowNA} that inputs and
outputs a data.frame.
}
\examples{
vrb_list <- lapply(X = c("O","C","E","A","N"), FUN = function(chr) {
   tmp <- grepl(pattern = chr, x = names(psych::bfi))
   names(psych::bfi)[tmp]
})
rowsNA(data = psych::bfi,
   vrb.nm.list = vrb_list) # names set to first elements in `vrb.nm.list`[[i]]
names(vrb_list) <- paste0(c("O","C","E","A","N"), "_m")
rowsNA(data = psych::bfi, vrb.nm.list = vrb_list) # names set to names(`vrb.nm.list`)
}
\seealso{
\code{\link{rowNA}}
   \code{\link{colNA}}
   \code{\link{vecNA}}
   \code{\link{is.na}}
}
