% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{freq}
\alias{freq}
\title{Univariate Frequency Table}
\usage{
freq(
  x,
  exclude = if (useNA == "no") c(NA, NaN),
  useNA = "always",
  prop = FALSE,
  sort = "frequency",
  decreasing = TRUE,
  na.last = TRUE
)
}
\arguments{
\item{x}{atomic vector or list vector. If not a vector, it will be coerced to
a vector via \code{\link{as.vector}}.}

\item{exclude}{unique values of \code{x} to exclude from the returned table.
If NULL, then missing values are always included in the returned table. See
\code{\link{table}} for documentation on the same argument.}

\item{useNA}{character vector of length 1 specifying how to handle missing
values (i.e., whether to include NA as an element in the returned table).
There are three options: 1) "no" = don't include missing values in the
table, 2) "ifany" = include missing values if there are any, 3) "always" =
include missing values in the table, regardless of whether there are any or
not. See \code{\link{table}} for documentation on the same argument.}

\item{prop}{logical vector of length 1 specifying whether the returned table
should include counts (FALSE) or proportions (TRUE). If NAs are excluded
(e.g., useNA = "no" or exclude = c(NA, NaN)), then the proportions will be
based on the number of observed elements.}

\item{sort}{character vector of length 1 specifying how the returned table
will be sorted. There are three options: 1) "frequency" = the frequency of
the unique values in \code{x}, 2) "position" = the position when each
unique value first appears in \code{x}, 3) "alphanum" = alphanumeric
ordering of the unique values in \code{x} (the sorting used by
\code{table}). When "frequency" is specified and there are ties, then the
ties are sorted alphanumerically.}

\item{decreasing}{logical vector of length 1 specifying whether the table
should be sorted in decreasing (TRUE) or increasing (FALSE) order.}

\item{na.last}{logical vector of length 1 specifying whether the table should
have NAs last or in whatever position they end up at. This argument is only
relevant if NAs exist in \code{x} and are included in the table (e.g.,
useNA = "always" or exclude = NULL).}
}
\value{
numeric vector of frequencies as either counts (if \code{prop} =
  FALSE) or proportions (if \code{prop} = TRUE) with the unique values of
  \code{x} as names (missing values have name = "(NA)"). Note, this is
  different from \code{table}, which returns a 1D-array and has class
  "table".
}
\description{
\code{freq} creates univariate frequency tables similar to \code{table}. It
differs from \code{table} by allowing for custom sorting by something other
than the alphanumerics of the unique values as well as returning an atomic
vector rather than a 1D-array.
}
\details{
The name for the table element giving the frequency of missing values is
"(NA)". This is different from \code{table} where the name is
\code{NA_character_}. This change allows for the sorting of tables that
include missing values, as subsetting in R is not possible with
\code{NA_character_} names. In future versions of the package, this might
change as it should be possible to avoid this issue by subetting with a
logical vector or integer indices instead of names. However, it is convenient
to be able to subset the return object fully by names.
}
\examples{
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = FALSE,
   sort = "frequency", decreasing = TRUE, na.last = TRUE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = FALSE,
   sort = "frequency", decreasing = TRUE, na.last = FALSE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = TRUE,
   sort = "frequency", decreasing = FALSE, na.last = TRUE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = TRUE,
   sort = "frequency", decreasing = FALSE, na.last = FALSE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = FALSE,
   sort = "position", decreasing = TRUE, na.last = TRUE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = FALSE,
   sort = "position", decreasing = TRUE, na.last = FALSE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = TRUE,
   sort = "position", decreasing = FALSE, na.last = TRUE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = TRUE,
   sort = "position", decreasing = FALSE, na.last = FALSE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = FALSE,
   sort = "alphanum", decreasing = TRUE, na.last = TRUE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = FALSE,
   sort = "alphanum", decreasing = TRUE, na.last = FALSE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = TRUE,
   sort = "alphanum", decreasing = FALSE, na.last = TRUE)
freq(c(mtcars$"carb", NA, NA, mtcars$"gear"), prop = TRUE,
   sort = "alphanum", decreasing = FALSE, na.last = FALSE)
}
\seealso{
\code{\link{freqs}}
   \code{\link{freq_by}}
   \code{\link{freqs_by}}
   \code{\link{table}}
}
