% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{decomposes}
\alias{decomposes}
\title{Decompose Numeric Data by Group}
\usage{
decomposes(
  data,
  vrb.nm,
  grp.nm,
  grand = TRUE,
  n.shift = NULL,
  undefined = NA,
  suffix.wth = "_w",
  suffix.btw = "_b",
  suffix.grand = "c",
  suffix.lead = "_dw",
  suffix.lag = "_gw"
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{grand}{logical vector of length 1 specifying whether grand-mean
centered versions of the the between-group components should be computed.}

\item{n.shift}{integer vector specifying the direction and magnitude of the
shifts. For example a one-lead is +1 and a two-lag is -2. See
\code{Shift_by} details.}

\item{undefined}{atomic vector of length 1 (probably makes sense to be the
same typeof as the vectors in \code{data[vrb.nm]}). Specifies what to
insert for undefined values after the shifting takes place. See details of
\code{Shift_by}.}

\item{suffix.wth}{character vector with a single element specifying the
string to append to the end of the within-group component colnames of the
return object.}

\item{suffix.btw}{character vector with a single element specifying the
string to append to the end of the between-group component colnames of the
return object.}

\item{suffix.grand}{character vector with a single element specifying the
string to append to the end of the grand-mean centered version of the
between-group component colnames of the return object. Note, this is a
string that is appended after \code{suffix.btw} has already been appended.}

\item{suffix.lead}{character vector with a single element specifying the
string to append to the end of the positive shift colnames of the return
object. Note, \code{decomposes} will add \code{abs(n.shift)} to the end of
\code{suffix.lead}.}

\item{suffix.lag}{character vector with a single element specifying the
string to append to the end of the negative shift colnames of the return
object. Note, \code{decomposes} will add \code{abs(n.shift)} to the end of
\code{suffix.lag}.}
}
\value{
data.frame with nrow = \code{nrow(data} and rownames =
  \code{row.names(data)}. The first set of columns correspond to the
  within-group components, followed by the between-group components. If grand
  = TRUE, then the next set of columns correspond to the grand-mean centered
  between-group components. If shift != NULL, then the last columns are the
  shifts by group indicated by n.shift, where the shifts of
  \code{data[vrb.nm]} are first and then the shifts of the within-group
  components are second.
}
\description{
\code{decomposes} decomposes numeric data by group into within-group and
between- group components via within-group centering and group-mean
aggregation. There is an option to create a grand-mean centered version of
the between-group components.
}
\examples{
ChickWeight2 <- as.data.frame(ChickWeight)
row.names(ChickWeight2) <- as.numeric(row.names(ChickWeight)) / 1000
decomposes(data = ChickWeight2, vrb.nm = c("weight","Time"), grp.nm = "Chick")
decomposes(data = ChickWeight2, vrb.nm = c("weight","Time"), grp.nm = "Chick",
   suffix.wth = ".wth", suffix.btw = ".btw", suffix.grand = ".grand")
decomposes(data = as.data.frame(CO2), vrb.nm = c("conc","uptake"),
   grp.nm = c("Type","Treatment")) # multiple grouping columns
decomposes(data = as.data.frame(CO2), vrb.nm = c("conc","uptake"),
   grp.nm = c("Type","Treatment"), n.shift = 1) # with lead
decomposes(data = as.data.frame(CO2), vrb.nm = c("conc","uptake"), grp.nm = c("Type","Treatment"),
   n.shift = c(+2, +1, -1, -2)) # with multiple lead/lags
}
\seealso{
\code{\link{decompose}}
   \code{\link{centers_by}}
   \code{\link{aggs}}
   \code{\link{shifts_by}}
}
