% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{centers_by}
\alias{centers_by}
\title{Centering and/or Standardizing Numeric Data by Group}
\usage{
centers_by(data, vrb.nm, grp.nm, center = TRUE, scale = FALSE, suffix)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{center}{logical vector with length 1 specifying whether group-mean
centering should be done.}

\item{scale}{logical vector with length 1 specifying whether group-SD scaling
should be done.}

\item{suffix}{character vector with a single element specifying the string to
append to the end of the colnames of the return object. The default depends
on the \code{center} and \code{scale} arguments: 1)if \code{center} = TRUE
and \code{scale} = FALSE, then \code{suffix} = "_cw", 2) if \code{center} =
FALSE and \code{scale} = TRUE, then \code{suffix} = "_sw", 3) if
\code{center} = TRUE and \code{scale} = TRUE, then \code{suffix} = "_zw",
4) if \code{center} = FALSE and \code{scale} = FALSE, then \code{suffix} =
"".}
}
\value{
data.frame of centered and/or standardized variables by group with
  colnames specified by \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{centers_by} centers and/or standardized data by group. This is sometimes
called group-mean centering and/or group-SD standardizing. The groups can be
specified by multiple columns in \code{data} (e.g., \code{grp.nm} with length
> 1), and \code{interaction} will be implicitly called to create the groups.
}
\details{
\code{centers_by} first coerces \code{data[vrb.nm]} to a matrix in preparation
for the core of the function, which is essentially \code{lapply(X = split(x =
data[vrb.nm], f = data[grp.nm]), FUN = scale.default)} If the coercion
results in a non-numeric matrix (e.g., any columns in \code{data[vrb.nm]} are
character vectors or factors), then an error is returned.
}
\examples{
ChickWeight2 <- as.data.frame(ChickWeight) # because the "groupedData" class calls
   # `[.groupedData`, which is different than `[.data.frame`
row.names(ChickWeight2) <- as.numeric(row.names(ChickWeight)) / 1000
centers_by(data = ChickWeight2, vrb.nm = c("weight","Time"), grp.nm = "Chick")
centers_by(data = ChickWeight2, vrb.nm = c("weight","Time"), grp.nm = "Chick",
   scale = TRUE, suffix = "_within")
centers_by(data = as.data.frame(CO2), vrb.nm = c("conc","uptake"),
   grp.nm = c("Type","Treatment"), scale = TRUE) # multiple grouping columns
}
\seealso{
\code{\link{center_by}}
   \code{\link{centers}}
   \code{\link{center}}
   \code{\link{scale.default}}
}
