% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_irt.R
\name{predict_irt}
\alias{predict_irt}
\title{Calculate Probabilities for Dynamic Item Response Theory Model}
\usage{
predict_irt(vote_info, years_v, post_samples)
}
\arguments{
\item{vote_info}{A logical vote matrix where rows represent members and columns represent issues.
The entries should be FALSE ("No"), TRUE ("Yes"), or NA (missing data).}

\item{years_v}{A vector representing the time period for each vote in the model.}

\item{post_samples}{MCMC results obtained from `wnominate' function in `wnominate' package.}
}
\value{
An array of probabilities with three dimensions. The first one represents to members, the second one refers to issues,
and the third one refers to MCMC iterations.
}
\description{
This function computes the probability matrix for a dynamic item response theory (IRT) model.
Specifically, it calculates the probabilities of voting "Yea" for each legislator (member),
issue, and time period based on the posterior samples of model parameters.
}
\examples{
\donttest{
# Long-running example
data(scotus.1937.2021)
library(MCMCpack)
special_judge_ind = sapply(c("HLBlack", "PStewart", "WHRehnquist"),
                           function(name){grep(name, rownames(mqVotes))})
e0_v = rep(0, nrow(mqVotes))
E0_v = rep(1, nrow(mqVotes))
e0_v[special_judge_ind] = c(-2, 1, 3)
E0_v[special_judge_ind] = c(10, 10, 10)
theta.start = rep(0, nrow(mqVotes))
indices = c(2, 5, 8, 9, 12, 22, 23, 24, 25, 29, 30, 33, 36, 39,
            42, 43, 44)
values = c(1, 1, -1, -2, -2, 1, -1, 1, 1, -1, 1, 3, 3, 3, 1, 1, -1)
theta.start[indices] = values
data(scotus.1937.2021)
scotus.MQ = MCMCdynamicIRT1d(mqVotes, mqTime, mcmc = 2,
                             burnin = 0, thin = 1, tau2.start = 0.1,
                             theta.start = theta.start, a0 = 0, A0 = 1, b0 = 0, B0 = 1, c0 = -10,
                             d0 = -2, e0 = e0_v, E0 = E0_v,
                             theta.constraints=list(CThomas = "+", SAAlito = "+", WJBrennan = "-",
                                                    WODouglas = "-", CEWhittaker = "+"))
scotus.MQ.predprob = predict_irt(mqVotes, mqTime, scotus.MQ)
}
}
