% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot_alphabeta.R
\name{.alpha}
\alias{.alpha}
\title{Calculate Alpha Irreplaceability}
\usage{
.alpha(local, global, target, triage = FALSE, na.allow = FALSE)
}
\arguments{
\item{local}{numeric - The feature's local representation at the site.}

\item{global}{numeric - The feature's globally available representation.}

\item{target}{numeric - The feature's target.}

\item{triage}{logical - Should features with unachievable targets be ignored?
Defaults to FALSE. If FALSE, these species will be always assigned an Alpha
irreplaceability of 1 wherever they occur. If TRUE, these species will always
be assigned an Alpha irreplaceabiltiy of 0.}

\item{na.allow}{logical - Return NA if NA values are found in the inputs?}
}
\value{
A number between 0 and 1.
}
\description{
This function calculates Alpha Irreplaceability for a single feature.
}
\details{
If na.allow is \code{TRUE} and any of the required values is NA, returns NA.

If triage is set to \code{TRUE}, alpha irreplaceability is set to 0 if the target
cannot be achieved (i.e., if the target is greater than the global value),
and calculated normally otherwise.
}
\examples{
.alpha(local=0,    global=100,  target=50)
.alpha(local=15,   global=100,  target=50)
.alpha(local=35,   global=100,  target=50)
.alpha(local=49.5, global=100,  target=50)
.alpha(local=55,   global=100,  target=50)
.alpha(local=100,  global=100,  target=0)
.alpha(local=5,    global=100,  target=110)
.alpha(local=5,    global=100,  target=110, triage=TRUE)
.alpha(local=32,   global=100,  target=NA, na.allow = TRUE)
}
\references{
\doi{10.1111/cobi.13806}
}
\author{
Daniele Baisero, \email{daniele.baisero@gmail.com}
}
\keyword{internal}
