% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/due_date.R
\name{calculate_due_date}
\alias{calculate_due_date}
\title{Calculate estimated due date and birth period}
\usage{
calculate_due_date(
  start_date,
  start_type = c("LMP", "conception", "transfer_day_3", "transfer_day_5",
    "transfer_day_6"),
  cycle = 28
)
}
\arguments{
\item{start_date}{Date or character string representing a date, e.g. "YYYY-MM-DD".
The starting reference date. The interpretation of this date depends on the
\code{start_type} parameter.}

\item{start_type}{character. One of:
\itemize{
\item "LMP": Last Menstrual Period date (default)
\item "conception": Date of conception
\item "transfer_day_3": Date of day 3 embryo transfer
\item "transfer_day_5": Date of day 5 embryo transfer
\item "transfer_day_6": Date of day 6 embryo transfer
}}

\item{cycle}{numeric. Length of menstrual cycle in days. Only used when
\code{start_type = "LMP"}. Must be between 20 and 44 days. Defaults to 28 days.}
}
\value{
Returns a Date object representing the estimated due date invisibly.
Also prints informative messages showing:
\itemize{
\item The estimated due date
\item When the birth period begins (37 weeks)
\item When the birth period ends (42 weeks)
}
}
\description{
Calculates the estimated due date based on a start date and type. The function
supports different start date types including last menstrual period (LMP),
conception date, and embryo transfer dates. It also provides an estimated birth
period, which spans from 37 weeks (birth period start) to 42 weeks (birth period
end).
}
\details{
The due date is calculated as follows:
\itemize{
\item For LMP: Ovulation is estimated as \verb{start_date + cycle - 14 days}, then
266 days are added
\item For conception: 266 days are added to the conception date
\item For embryo transfers: The appropriate number of days are subtracted to get
to conception date (3, 5, or 6 days), then 266 days are added
}

The birth period start date is 21 days before the due date (37 weeks pregnant),
and the birth period end date is 14 days after the due date (42 weeks pregnant).

#' If \code{start_date} is a character string, the conversion to a \code{Date}
is handled by \code{anytime::anydate()}.
}
\examples{
# Calculate due date from last menstrual period
calculate_due_date("2025-01-31")

# Calculate from conception date
calculate_due_date("2025-02-14", start_type = "conception")

# Calculate from day 5 embryo transfer
calculate_due_date(as.Date("2025-02-19"), start_type = "transfer_day_5")

# Calculate with non-standard cycle length
calculate_due_date("2025-01-31", cycle = 35)

}
\seealso{
\itemize{
\item \code{\link[=date_when]{date_when()}} for finding dates at specific weeks of pregnancy
\item \code{\link[=how_far]{how_far()}} for calculating current progress in pregnancy
}
}
