% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalstd.R
\name{getpaired}
\alias{getpaired}
\title{Filter ions/peaks based on retention time hierarchical clustering, paired mass distances(PMD) and PMD frequency analysis.}
\usage{
getpaired(
  list,
  rtcutoff = 10,
  ng = NULL,
  digits = 2,
  accuracy = 4,
  mdrange = NULL
)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{ng}{cutoff of global PMD's retention time group numbers, If ng = NULL, 20 percent of RT cluster will be used as ng, default NULL.}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}

\item{mdrange}{mass defect range to ignore. Default NULL and c(0.25,0.9) to retain the possible reaction related paired mass}
}
\value{
list with tentative isotope, multi-chargers, adducts, and neutral loss peaks' index, retention time clusters.
}
\description{
Filter ions/peaks based on retention time hierarchical clustering, paired mass distances(PMD) and PMD frequency analysis.
}
\examples{
data(spmeinvivo)
pmd <- getpaired(spmeinvivo)
}
\seealso{
\code{\link{getstd}},\code{\link{getsda}},\code{\link{plotpaired}}
}
