% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_transform.R
\name{op_transform}
\alias{op_transform}
\alias{marbles_transform}
\title{Oblique projection helper function}
\usage{
op_transform(
  df,
  ...,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  envir = getOption("piecepackr.envir"),
  op_angle = getOption("piecepackr.op_angle", 45),
  pt_thickness = 0.01,
  as_top = character(0),
  cfg_class = "list"
)

marbles_transform(df, ...)
}
\arguments{
\item{df}{A data frame with coordinates and dimensions in inches}

\item{...}{Ignored by \code{op_transform()}.  \code{marbles_transform()} passes to \code{op_transform()}.}

\item{cfg}{Piecepack configuration list or \code{\link[=pp_cfg]{pp_cfg()}} object,
a list of \code{\link[=pp_cfg]{pp_cfg()}} objects,
or a character vector of the names of \code{\link[=pp_cfg]{pp_cfg()}} objects contained in \code{envir}.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{op_angle}{Intended oblique projection angle (used for re-sorting)}

\item{pt_thickness}{Thickness of pyramid tip i.e. value to add to the z-value of a pyramid top
if it is a (weakly) smaller ranked pyramid (top)
placed on top of a larger ranked pyramid (top).}

\item{as_top}{Character vector of components whose \dQuote{side}
should be converted to \dQuote{top} e.g. \code{"pawn_face"}.}

\item{cfg_class}{Either \code{"list"} (default) or \code{"character"}.
Desired class of the \code{cfg} column in the returned tibble.
\code{"list"} is more efficient for use with \code{pmap_piece()} but
\code{geom_piece()} needs \code{"character"}.}
}
\value{
A tibble with extra columns added
and re-sorted rows
}
\description{
\code{op_transform()} guesses \code{z} coordinates and
sorting order to more easily
make 3D graphics with \code{\link[=pmap_piece]{pmap_piece()}}.
\code{marbles_transform()} is a wrapper around \code{op_transform()} that handles the special case
of stacking 1" marbles in a pyramid with a square base on a holed board.
}
\details{
The heuristics used to generate guesses
for \code{z} coordinates and sorting order
aren't guaranteed to work in every case.
In some cases you may get better sorting results
by changing the \code{op_angle} or the dimensions of pieces.
}
\examples{
df <- tibble::tibble(piece_side="tile_back",
                     x=c(2,2,2,4,6,6,4,2,5),
                     y=c(4,4,4,4,4,2,2,2,3))
cfg <- game_systems()$piecepack
pmap_piece(df, op_angle=135, trans=op_transform,
           op_scale=0.5, default.units="in", cfg=cfg)
}
\seealso{
\url{https://trevorldavis.com/piecepackr/3d-projections.html} for more details
and examples of oblique projections in \code{piecepackr}.
}
