% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_phylo.R
\name{drop.clade}
\alias{drop.clade}
\title{Drop a clade from a phylogentic tree}
\usage{
drop.clade(phy, node, root.edge = 0, collapse.singles = TRUE)
}
\arguments{
\item{phy}{an object of class "phylo".}

\item{node}{number specifying the parent node of the clade to delete.}

\item{root.edge, collapse.singles}{passed to \code{\link[ape:drop.tip]{ape::drop.tip()}}.}
}
\value{
New phylo object with the chosen clade removed
}
\description{
\code{drop.clade} invokes \code{\link[ape:drop.tip]{ape::drop.tip()}} on all tips descendent from the
specified node. This is convenient when used alongside \code{\link[ape:mrca]{ape::getMRCA()}} to
drop a clade defined by the most recent common ancestor of a set of tips,
rather than exhaustively specifying all of its tips.
}
\examples{
library("ape")
data(bird.orders)
plot(bird.orders)

# find the common ancestor of some tips
mrca <- ape::getMRCA(bird.orders, c("Passeriformes", "Coliiformes"))

# drop the clade descending from that ancestor
plot(drop.clade(bird.orders, mrca))
}
