% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phy.signal.R
\name{phy.signal}
\alias{phy.signal}
\title{Calculate phylogenetic `signal'}
\usage{
phy.signal(data, method = c("lambda", "delta", "kappa", "blom.k"))
}
\arguments{
\item{data}{\code{\link{comparative.comm}} object}

\item{method}{what kind of signal to calculate, one of Pagel's
lambda(default), delta, and kappa, or Blomberg's K.}
}
\value{
Named numeric vector, where each element is a trait or
  community.
}
\description{
Calculate phylogenetic `signal'
}
\details{
Phylogenetic `signal' is one of those concepts that is
  said a lot in community ecology, but some do not full consider
  its meaning. Think carefully before rushing to report a value
  whether: (1) it makes sense to assess phylogenetic `signal' in
  your datasets, and (2) what the phrase `phylogenetic signal'
  actually means. This code makes use of \code{\link[caper]{pgls}}
  to get estimates of fit; alternatives that offer more flexibility
  exist (see below).
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits)
phy.signal(data, "lambda")
}
\references{
Blomberg S.P., Garland T. & Ives A.R. Testing for
  phylogenetic signal in comparative data: behavioral traits are
  more labile. Evolution 57(4): 717--745.

R. P. Freckleton, P. H. Harvey, and
  M. Pagel. Phylogenetic analysis and comparative data: A test and
  review of evidence. American Naturalist, 160:712-726, 2002.

Mark Pagel (1999) Inferring the historical patterns of
  biological evolution. Nature 6756(401): 877--884.
}
\seealso{
fitContinuous fitDiscrete pgls phylosignal
}
\author{
Will Pearse, Jeannine Cavender-Bares
}
