% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testInformation.R
\name{test_info_4PL}
\alias{test_info_4PL}
\alias{error_variance_4PL}
\alias{reliability_4PL}
\title{Test Information from Logistic IRT Model.}
\usage{
test_info_4PL(
  theta,
  alpha,
  beta,
  gamma = rep(0, length(alpha)),
  delta = rep(1, length(alpha))
)

error_variance_4PL(
  lower = -Inf,
  upper = Inf,
  alpha,
  beta,
  gamma = rep(0, length(alpha)),
  delta = rep(1, length(alpha)),
  mean = 0,
  sd = 1,
  density_cutoff = 1e-10
)

reliability_4PL(
  alpha,
  beta,
  gamma = rep(0, length(alpha)),
  delta = rep(1, length(alpha))
)
}
\arguments{
\item{theta}{Numeric. The respondent's level on the latent factor/construct.}

\item{alpha}{Numeric. The discrimination parameter of the item,
indicating how steeply the item response changes with the person's
(\code{theta}).}

\item{beta}{Numeric. The difficulty parameter of the item,
indicating the expected count at a given level on the construct
(\code{theta}).}

\item{gamma}{Numeric. The lower asymptote.}

\item{delta}{Numeric. The upper asymptote.}

\item{lower}{Numeric. The lower range of theta, for estimating error variance
or reliability.}

\item{upper}{Numeric. The upper range of theta, for estimating error variance
or reliability.}

\item{mean}{Numeric. Mean of normal latent variable.}

\item{sd}{Numeric. Standard deviation of normal latent variable.}

\item{density_cutoff}{Numeric. Cut-off value for very large or very small
bounds needed for numerical stability.}
}
\value{
The amount of information for a given the test as a whole at each
of the values of \code{theta} specified. Based on test information, one can
estimate error variance and marginal reliability using
\code{error_variance_4PL()} and \code{reliability_4PL()}, respectively.
}
\description{
Estimate test information from logistic item response theory model.
}
\details{
Created by Philipp Doebler (doebler@statistik.tu-dortmund.de) and Loreen
Sabel (loreen.sabel@tu-dortmund.de).
}
\examples{
test_info_4PL(0,1,0,0,1) # 0.25
test_info_4PL(-0.849, 1.1, -1, 0.2, 0.95) # Magis, 2013, Fig. 2
optimize(function(x)- test_info_4PL(x, 1.1, -1, 0.2, 0.95), c(-3, 3))

# test
set.seed(23)
# parameters (some are totally unrealistic)
alpha <- runif(20,0.5,2.5)
beta <- runif(20,-2,2)
gamma <- runif(20,0,0.3)
delta <- runif(20,0.8,1)
error_variance_4PL(
  lower = -Inf, upper = Inf,
  alpha, beta, gamma, delta)

error_variance_4PL(
  lower= -Inf, upper= Inf,
  alpha, beta, gamma, delta,
  density_cutoff = 1e-9)

error_variance_4PL(
  lower= -Inf, upper= Inf,
  alpha, beta, gamma, delta,
  density_cutoff = 1e-8)

error_variance_4PL(
  lower = -Inf, upper= Inf,
  alpha, beta, gamma, delta,
  density_cutoff = 1e-7)

reliability_4PL(alpha, beta, gamma, delta)

theta <- seq(-4, 4, length.out = 101)

plot(theta, test_info_4PL(theta, alpha, beta, gamma, delta))
}
\seealso{
Other IRT: 
\code{\link{deriv_d_negBinom}()},
\code{\link{discriminationToFactorLoading}()},
\code{\link{fourPL}()},
\code{\link{itemInformation}()},
\code{\link{reliabilityIRT}()},
\code{\link{standardErrorIRT}()}
}
\concept{IRT}
