% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data_synth}
\alias{simulate_data_synth}
\alias{simulate_data}
\title{Simulate data according to synthetic control model}
\usage{
simulate_data_synth(
  N_donor = 50,
  N_treated = 1,
  N_covar = 5,
  N_pre = 12,
  N_post = 6,
  N_nonzero = 4,
  treatment_effect = 1,
  sd_resid_X = 0.1,
  sd_resid_ZY = 0.1,
  ar1_outcome = 0.8
)

simulate_data(
  N_donor = 50,
  N_treated = 1,
  N_covar = 5,
  N_pre = 12,
  N_post = 6,
  N_nonzero = 4,
  treatment_effect = 1,
  sd_resid_X = 0.1,
  sd_resid_ZY = 0.1,
  ar1_outcome = 0.8
)
}
\arguments{
\item{N_donor}{number of donors}

\item{N_treated}{number of treated units}

\item{N_covar}{number of covariates}

\item{N_pre}{number of pre-intervention timepoints}

\item{N_post}{number of post-intervention timepoints}

\item{N_nonzero}{number of true nonzero weights}

\item{treatment_effect}{the size of the true treatment effect}

\item{sd_resid_X}{the residual standard deviation of X1}

\item{sd_resid_ZY}{the residual standard deviation of Z1 and Y1}

\item{ar1_outcome}{autoregressive effect of the outcome}
}
\value{
A list with the following elements
\itemize{
\item W the true unit weights
\item X0 the donor unit covariates
\item X1 the treated unit covariates
\item Z0 the donor unit pre-intervention outcomes
\item Z1 the treated unit pre-intervention outcomes
\item Y0 the donor unit post-intervention outcomes
\item Y1 the treated unit post-intervention outcomes
}
}
\description{
This function simulates a basic form of synthetic control
data, mainly for testing purposes.
}
\details{
Note that treatment effect can be a single number, but
it may also be a vector of length N_post, indicating
the effect size at each post-intervention measurement.
occasion. It may also be a matrix of size N_post by
N_treated.
}
\examples{
# simulate data with an effect of 0.8 SD
dat <- simulate_data_synth(treatment_effect = 0.8)

plot(
  NA,
  ylim = c(-3, 3),
  xlim = c(1, 18),
  main = "Simulated data",
  ylab = "Outcome value",
  xlab = "Timepoint"
)
for (n in 1:ncol(dat$Z0))
  lines(1:18, c(dat$Z0[, n], dat$Y0[, n]), col = "grey")
lines(1:18, c(dat$Z1, dat$Y1), lwd = 2)
lines(1:18, rbind(dat$Z0, dat$Y0) \%*\% dat$W, lty = 2, lwd = 2)
abline(v = length(dat$Z1) + 0.5, lty = 3)
legend(
  x = "bottomleft",
  legend = c(
    "Donor units",
    "Treated unit",
    "Synth. control"
  ),
  lty = c(1, 1, 2),
  lwd = c(1, 2, 2),
  col = c("grey", "black", "black")
)
text(length(dat$Z1) + 0.5, -3, "Intervention\ntimepoint", pos = 4, font = 3)
}
\seealso{
\code{\link[=pensynth]{pensynth()}}, \code{\link[=cv_pensynth]{cv_pensynth()}}, \code{\link[=placebo_test]{placebo_test()}}, \code{\link[=simulate_data_factor]{simulate_data_factor()}}
}
