% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McCullagh_palindromic_symmetry.R
\name{McCullagh_palindromic_symmetry}
\alias{McCullagh_palindromic_symmetry}
\title{McCullagh's palindromic symmetry model}
\usage{
McCullagh_palindromic_symmetry(n, max_iter = 15, verbose = FALSE)
}
\arguments{
\item{n}{matrix of observed counts}

\item{max_iter}{maximum number of iterations to maximize the log(likelihood)}

\item{verbose}{should cycle-by-cycle info be printed out? Default is FALSE, don't print.}
}
\value{
a list containing
   delta: the value of the asymmetry parameter delta
   sigma_delta: SE(delta)
   logL: value of log(likelihood) for final estimates
   chisq: Pearson chi-square for solution
   df: degrees of freedom for solution chisq
   psi: matrix of symmetry parameters
   alpha:
   c: constraint, sum of pi - values
   condition: constraint on psi to make model identified, Lagrange multiplier
   SE: vector of standard errors for all parameters
}
\description{
McCullagh, P. (1978). A class of parametric models for the analysis of
square contingency tables with ordered categories. Biometrika, 65(2). 413-416.
}
\examples{
McCullagh_palindromic_symmetry(vision_data)
}
