% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bfgs_b.R
\name{l_bfgs_b}
\alias{l_bfgs_b}
\title{Limited-memory BFGS with Box Constraints (L-BFGS-B)}
\usage{
l_bfgs_b(
  start,
  objective,
  gradient = NULL,
  hessian = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Initial values for the parameters.}

\item{objective}{Function. The scalar objective function to be minimized.}

\item{gradient}{Function (optional). Returns the gradient vector. If \code{NULL}, 
numerical derivatives are used.}

\item{hessian}{Function (optional). Returns the Hessian matrix. Used for final 
positive definiteness verification if \code{use_posdef = TRUE}.}

\item{lower, upper}{Numeric vectors. Lower and upper bounds for the parameters. 
Can be scalars if all parameters share the same bounds.}

\item{control}{A list of control parameters:
\itemize{
  \item \code{use_abs_f}: Logical. Criterion: \eqn{|f_{new} - f_{old}| <} \code{tol_abs_f}.
  \item \code{use_rel_f}: Logical. Criterion: \eqn{|(f_{new} - f_{old}) / f_{old}| <} \code{tol_rel_f}.
  \item \code{use_abs_x}: Logical. Criterion: \eqn{\max |x_{new} - x_{old}| <} \code{tol_abs_x}.
  \item \code{use_rel_x}: Logical. Criterion: \eqn{\max |(x_{new} - x_{old}) / x_{old}| <} \code{tol_rel_x}.
  \item \code{use_grad}: Logical. Criterion: \eqn{\|g\|_\infty <} \code{tol_grad}.
  \item \code{use_posdef}: Logical. Criterion: Positive definiteness of the Hessian.
  \item \code{max_iter}: Maximum number of iterations (default: 10000).
  \item \code{m}: Number of L-BFGS memory updates (default: 5).
  \item \code{tol_abs_f}, \code{tol_rel_f}: Tolerances for function value change.
  \item \code{tol_abs_x}, \code{tol_rel_x}: Tolerances for parameter change.
  \item \code{tol_grad}: Tolerance for the projected gradient (default: 1e-4).
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and metadata.
}
\description{
Performs bound-constrained minimization using the L-BFGS-B algorithm. 
This implementation handles box constraints via Generalized Cauchy Point (GCP) 
estimation and subspace minimization, featuring a limited-memory (two-loop recursion) 
inverse Hessian approximation.
}
\section{Comparison with Existing Functions}{

This function adds three features for rigorous convergence control. First, it 
applies an \bold{AND rule}: all selected convergence criteria must be satisfied 
simultaneously. Second, users can choose among \bold{eight distinct criteria} 
(e.g., changes in \eqn{f}, \eqn{x}, gradient, or predicted decrease) instead of relying 
on fixed defaults. Third, it provides an \bold{optional verification} using the 
Hessian computed from derivatives (analytically when provided, or via numerical 
differentiation). Checking the positive definiteness of this Hessian at the final 
solution reduces the risk of declaring convergence at non-minimizing stationary 
points, such as saddle points.
}

\references{
Byrd, R. H., Lu, P., Nocedal, J., & Zhu, C. (1995). A limited memory algorithm 
for bound constrained optimization. \emph{SIAM Journal on Scientific Computing}, 
16(5), 1190-1208.

Morales, J. L., & Nocedal, J. (2011). L-BFGS-B: Remark on algorithm 778: 
L-BFGS-B: Fortran subroutines for large-scale bound-constrained optimization. 
\emph{ACM Transactions on Mathematical Software}, 38(1), 1-4.
}
