% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socket.R
\name{monitor}
\alias{monitor}
\alias{read_monitor}
\title{Monitor a Socket for Pipe Changes}
\usage{
monitor(sock, cv)

read_monitor(x)
}
\arguments{
\item{sock}{a Socket.}

\item{cv}{a 'conditionVariable'.}

\item{x}{a Monitor.}
}
\value{
For \code{monitor}: a Monitor (object of class 'nanoMonitor'). \cr
For \code{read_monitor}: an integer vector of pipe IDs (positive if added,
negative if removed), or else NULL if there were no changes since the
previous read.
}
\description{
This function monitors pipe additions and removals from a socket.
}
\examples{
cv <- cv()
s <- socket("poly")
s1 <- socket("poly")

m <- monitor(s, cv)
m

listen(s)
dial(s1)

cv_value(cv)
read_monitor(m)

close(s)
close(s1)

read_monitor(m)

}
