% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam_forecast-class.R
\name{mvgam_forecast-class}
\alias{mvgam_forecast-class}
\title{\code{mvgam_forecast} object description}
\description{
A \code{mvgam_forecast} object returned by function \code{\link{hindcast}}
or \code{\link{forecast}}. Run \code{methods(class = "mvgam_forecast")} to see
an overview of available methods.
}
\details{
A \code{mvgam_forecast} object contains the following elements:

\itemize{
\item \code{call} the original observation model formula

\item \code{trend_call} If a \verb{trend_formula was supplied}, the original trend
model formula is returned. Otherwise \code{NULL}

\item \code{family} \code{character} description of the observation distribution

\item \code{family_pars} \code{list} containing draws of family-specific
parameters (i.e. shape, scale or overdispersion parameters). Only
returned if \code{type = link}. Otherwise \code{NULL}

\item \code{trend_model} \code{character} description of the latent trend model

\item \code{drift} Logical specifying whether a drift term was used in the
trend model

\item \code{use_lv} Logical flag indicating whether latent dynamic factors were
used in the model

\item \code{fit_engine} \code{Character} describing the fit engine, either as \code{stan}
or \code{jags}

\item \code{type} The type of predictions included (either \code{link}, \code{response}
or \code{trend})

\item \code{series_names} Names of the time series, taken from
\code{levels(data$series)} in the original model fit

\item \code{train_observations} A \code{list} of training observation vectors of
length \code{n_series}

\item \code{train_times} A \code{list} of the unique training times of length
\code{n_series}

\item \code{test_observations} If the \code{\link{forecast}} function was used,
a \code{list} of test observation vectors of length \code{n_series}. Otherwise
\code{NULL}

\item \code{test_times} If the \code{\link{forecast}} function was used, a
\code{list} of the unique testing (validation) times of length \code{n_series}.
Otherwise \code{NULL}

\item \code{hindcasts} A \code{list} of posterior hindcast distributions of length
\code{n_series}.

\item \code{forecasts} If the \code{\link{forecast}} function was used, a
\code{list} of posterior forecast distributions of length \code{n_series}.
Otherwise \code{NULL}
}
}
\seealso{
\link{mvgam}, \link{hindcast.mvgam}, \link{forecast.mvgam}
}
\author{
Nicholas J Clark
}
