test_that("optc_test returns correct result overall", {
  expect_false(optc_test(c(0, 3, 14)))
  expect_false(optc_test(c(0, 7, 19), edo=15))
  expect_false(optc_test(c(0, 3, 2)))
  expect_false(optc_test(c(1, 0, 3, 9)))
  expect_false(optc_test(c(0, 5, 5)))
  expect_false(optc_test(c(0, 5, 5 + 1e-13)))
  expect_true(optc_test(c(0, 5, 5 + 1e-13), rounder=14))
  expect_false(optc_test(c(0, 5 + 1e-13, 5), rounder=14))
  expect_false(optc_test(c(1,3,5,7,9,11)))
  expect_false(optc_test(c(-.001, 3, 4)))
})

test_that("OPTC individual tests indexed well", {
  expect_false(optc_test(c(0, 3, 14), single_answer=FALSE)["O"])
  expect_false(optc_test(c(0, 7, 19), edo=15, single_answer=FALSE)["O"])
  expect_false(optc_test(c(0, 3, 2), single_answer=FALSE)["P"])
  expect_false(optc_test(c(1, 0, 3, 9), single_answer=FALSE)["P"])
  expect_false(optc_test(c(0, 5, 5), single_answer=FALSE)["C"])
  expect_false(optc_test(c(0, 5, 5 + 1e-13), single_answer=FALSE)["C"])
  expect_equal(sum(optc_test(c(0, 5, 5 + 1e-13), rounder=14, single_answer=FALSE)), 4)
  expect_false(optc_test(c(0, 5 + 1e-13, 5), rounder=14, single_answer=FALSE)["P"])
  expect_false(optc_test(c(1,3,5,7,9,11), single_answer=FALSE)["T"])
  expect_false(optc_test(c(-.001, 3, 4), single_answer=FALSE)["T"])
})