% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{ssh_config}
\alias{ssh_config}
\title{SSH Remote Launch Configuration}
\usage{
ssh_config(
  remotes,
  tunnel = FALSE,
  timeout = 10,
  command = "ssh",
  rscript = "Rscript"
)
}
\arguments{
\item{remotes}{the character URL or vector of URLs to SSH into, using the
'ssh://' scheme and including the port open for SSH connections (defaults
to 22 if not specified), e.g. 'ssh://10.75.32.90:22' or 'ssh://nodename'.}

\item{tunnel}{logical value, whether to use SSH tunnelling. If TRUE, requires
the \code{\link[=daemons]{daemons()}} \code{url} hostname to be '127.0.0.1'. See the 'SSH Tunnelling'
section below for further details.}

\item{timeout}{maximum time in seconds allowed for connection setup.}

\item{command}{the command used to effect the daemon launch on the remote
machine as a character string (e.g. \code{"ssh"}). Defaults to \code{"ssh"} for
\code{ssh_config}, although may be substituted for the full path to a specific
SSH application. The default NULL for \code{remote_config} does not carry out
any launches, but causes \code{\link[=launch_remote]{launch_remote()}} to return the shell commands for
manual deployment on remote machines.}

\item{rscript}{filename of the R executable. Use the full path of the Rscript
executable on the remote machine if necessary. If launching on Windows,
\code{"Rscript"} should be replaced with \code{"Rscript.exe"}.}
}
\value{
A list in the required format to be supplied to the \code{remote} argument
of \code{\link[=daemons]{daemons()}} or \code{\link[=launch_remote]{launch_remote()}}.
}
\description{
Generates a remote configuration for launching daemons over SSH, with the
option of SSH tunnelling.
}
\section{SSH Direct Connections}{


The simplest use of SSH is to execute the daemon launch command on a remote
machine, for it to dial back to the host / dispatcher URL.

It is assumed that SSH key-based authentication is already in place. The
relevant port on the host must also be open to inbound connections from the
remote machine, and is hence suitable for use within trusted networks.
}

\section{SSH Tunnelling}{


Use of SSH tunnelling provides a convenient way to launch remote daemons
without requiring the remote machine to be able to access the host. Often
firewall configurations or security policies may prevent opening a port to
accept outside connections.

In these cases SSH tunnelling offers a solution by creating a tunnel once the
initial SSH connection is made. For simplicity, this SSH tunnelling
implementation uses the same port on both host and daemon. SSH key-based
authentication must already be in place, but no other configuration is
required.

To use tunnelling, set the hostname of the \code{\link[=daemons]{daemons()}} \code{url} argument to be
'127.0.0.1'. Using \code{\link[=local_url]{local_url()}} with \code{tcp = TRUE} also does this for you.
Specifying a specific port to use is optional, with a random ephemeral port
assigned otherwise. For example, specifying 'tcp://127.0.0.1:5555' uses the
local port '5555' to create the tunnel on each machine. The host listens
to '127.0.0.1:5555' on its machine and the remotes each dial into
'127.0.0.1:5555' on their own respective machines.

This provides a means of launching daemons on any machine you are able to
access via SSH, be it on the local network or the cloud.
}

\examples{
# direct SSH example
ssh_config(c("ssh://10.75.32.90:222", "ssh://nodename"), timeout = 5)

# SSH tunnelling example
ssh_config(c("ssh://10.75.32.90:222", "ssh://nodename"), tunnel = TRUE)

\dontrun{

# launch daemons on the remote machines 10.75.32.90 and 10.75.32.91 using
# SSH, connecting back directly to the host URL over a TLS connection:
daemons(
  n = 1,
  url = host_url(tls = TRUE),
  remote = ssh_config(c("ssh://10.75.32.90:222", "ssh://10.75.32.91:222"))
)

# launch 2 daemons on the remote machine 10.75.32.90 using SSH tunnelling:
daemons(
  n = 2,
  url = local_url(tcp = TRUE),
  remote = ssh_config("ssh://10.75.32.90", tunnel = TRUE)
)
}

}
\seealso{
\code{\link[=cluster_config]{cluster_config()}} for cluster resource manager launch
configurations, or \code{\link[=remote_config]{remote_config()}} for generic configurations.
}
