% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{bootstrap_performance}
\alias{bootstrap_performance}
\title{Calculate a bootstrap confidence interval for the performance on a single train/test split}
\usage{
bootstrap_performance(
  ml_result,
  outcome_colname,
  bootstrap_times = 10000,
  alpha = 0.05
)
}
\arguments{
\item{ml_result}{result returned from a single \code{\link[=run_ml]{run_ml()}} call}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}

\item{bootstrap_times}{the number of boostraps to create (default: \code{10000})}

\item{alpha}{the alpha level for the confidence interval (default \code{0.05} to create a 95\% confidence interval)}
}
\value{
a data frame with an estimate (\code{.estimate}), lower bound (\code{.lower}),
and upper bound (\code{.upper}) for each performance metric (\code{term}).
}
\description{
Uses \code{\link[rsample:bootstraps]{rsample::bootstraps()}}, \code{\link[rsample:int_pctl]{rsample::int_pctl()}}, and \code{\link[furrr:future_map]{furrr::future_map()}}
}
\examples{
bootstrap_performance(otu_mini_bin_results_glmnet, "dx",
  bootstrap_times = 10, alpha = 0.10
)
\dontrun{
outcome_colname <- "dx"
run_ml(otu_mini_bin, "rf", outcome_colname = "dx") \%>\%
  bootstrap_performance(outcome_colname,
    bootstrap_times = 10000,
    alpha = 0.05
  )
}
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}
}
