% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io_functions.R
\name{create_analysis_report}
\alias{create_analysis_report}
\title{Create Analysis Report}
\usage{
create_analysis_report(
  results,
  output_path,
  format = "html",
  title = "Manureshed Analysis Report",
  include_maps = TRUE
)
}
\arguments{
\item{results}{List. Complete analysis results}

\item{output_path}{Character. Path for output report}

\item{format}{Character. Report format: "html" or "pdf"}

\item{title}{Character. Report title}

\item{include_maps}{Logical. Whether to include maps in report}
}
\value{
Character. Path to generated report
}
\description{
Generate comprehensive HTML or PDF report of analysis results
}
\examples{
\donttest{
# Generate HTML report - use tempdir to avoid check directory pollution
results <- run_builtin_analysis(scale = "county", year = 2016)
report_path <- file.path(tempdir(), "analysis_report.html")
create_analysis_report(results, report_path)
}
}
