% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{dt_left_join}
\alias{dt_left_join}
\alias{dt_right_join}
\alias{dt_inner_join}
\alias{dt_full_join}
\alias{dt_semi_join}
\alias{dt_anti_join}
\title{Join two data.frames by common columns.}
\usage{
dt_left_join(x, y, by = NULL, suffix = c(".x", ".y"))

dt_right_join(x, y, by = NULL, suffix = c(".x", ".y"))

dt_inner_join(x, y, by = NULL, suffix = c(".x", ".y"))

dt_full_join(x, y, by = NULL, suffix = c(".x", ".y"))

dt_semi_join(x, y, by = NULL)

dt_anti_join(x, y, by = NULL)
}
\arguments{
\item{x}{data.frame or data.table}

\item{y}{data.frame or data.table}

\item{by}{a character vector of variables to join by. If NULL, the default,
*_join() will do a natural join, using all variables with common names
across the two tables. A message lists the variables so that you can check
they're right (to suppress the message, simply explicitly list the
variables that you want to join). To join by different variables on x and y
use a named vector. For example, \code{by = c("a" = "b")} will match x.a to y.b.}

\item{suffix}{If there are non-joined duplicate variables in x and y, these
suffixes will be added to the output to disambiguate them. Should be a
character vector of length 2.}
}
\value{
data.table
}
\description{
Do different versions of SQL join operations. See examples.
}
\examples{
workers = fread("
    name company
    Nick Acme
    John Ajax
    Daniela Ajax
")

positions = fread("
    name position
    John designer
    Daniela engineer
    Cathie manager
")

workers \%>\% dt_inner_join(positions)
workers \%>\% dt_left_join(positions)
workers \%>\% dt_right_join(positions)
workers \%>\% dt_full_join(positions)

# filtering joins
workers \%>\% dt_anti_join(positions)
workers \%>\% dt_semi_join(positions)

# To suppress the message, supply 'by' argument
workers \%>\% dt_left_join(positions, by = "name")

# Use a named 'by' if the join variables have different names
positions2 = setNames(positions, c("worker", "position")) # rename first column in 'positions'
workers \%>\% dt_inner_join(positions2, by = c("name" = "worker"))
}
