% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks-monitor-metrics.R
\name{luz_callback_early_stopping}
\alias{luz_callback_early_stopping}
\title{Early stopping callback}
\usage{
luz_callback_early_stopping(
  monitor = "valid_loss",
  min_delta = 0,
  patience = 0,
  mode = "min",
  baseline = NULL
)
}
\arguments{
\item{monitor}{A string in the format \verb{<set>_<metric>} where \verb{<set>} can be
'train' or 'valid' and \verb{<metric>} can be the abbreviation of any metric
that you are tracking during training. The metric name is case insensitive.}

\item{min_delta}{Minimum improvement to reset the patience counter.}

\item{patience}{Number of epochs without improving until stoping training.}

\item{mode}{Specifies the direction that is considered an improvement. By default
'min' is used. Can also be 'max' (higher is better) and 'zero'
(closer to zero is better).}

\item{baseline}{An initial value that will be used as the best seen value
in the begining. Model will stop training if no better than baseline value
is found in the first \code{patience} epochs.}
}
\value{
A \code{luz_callback} that does early stopping.
}
\description{
Stops training when a monitored metric stops improving
}
\note{
This callback adds a \code{on_early_stopping} callback that can be used to
call callbacks as soon as the model stops training.

If \code{verbose=TRUE} in \code{\link[=fit.luz_module_generator]{fit.luz_module_generator()}} a message is printed when
early stopping.
}
\examples{
cb <- luz_callback_early_stopping()

}
\seealso{
Other luz_callbacks: 
\code{\link{luz_callback}()},
\code{\link{luz_callback_auto_resume}()},
\code{\link{luz_callback_csv_logger}()},
\code{\link{luz_callback_interrupt}()},
\code{\link{luz_callback_keep_best_model}()},
\code{\link{luz_callback_lr_scheduler}()},
\code{\link{luz_callback_metrics}()},
\code{\link{luz_callback_mixed_precision}()},
\code{\link{luz_callback_mixup}()},
\code{\link{luz_callback_model_checkpoint}()},
\code{\link{luz_callback_profile}()},
\code{\link{luz_callback_progress}()},
\code{\link{luz_callback_resume_from_checkpoint}()},
\code{\link{luz_callback_train_valid}()}
}
\concept{luz_callbacks}
