% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long.lang.R
\name{long.lang}
\alias{long.lang}
\title{Get longitude by language}
\usage{
long.lang(x, map.orientation = "Pacific")
}
\arguments{
\item{x}{A character vector of the languages (can be written in lower case)}

\item{map.orientation}{A character verctor with values "Pacific" and "Atlantic". It distinguishes Pacific-centered and Atlantic-centered maps. By default is "Pacific".}
}
\description{
Takes any vector of languages and returns longitude.
}
\examples{
lat.lang('Kabardian')
long.lang('Kabardian')
lat.lang(c('Kabardian', 'Russian'))
long.lang(c('Kabardian', 'Russian'))
long.lang(c('Kabardian', 'Aleut'), map.orientation = "Pacific")
}
\seealso{
\code{\link{aff.lang}}, \code{\link{area.lang}}, \code{\link{country.lang}}, \code{\link{gltc.lang}}, \code{\link{iso.lang}}, \code{\link{lat.lang}},  \code{\link{subc.lang}}, \code{\link{url.lang}}
}
\author{
George Moroz <agricolamz@gmail.com>
}
