% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmassesssimulation.R
\name{kmassessmentsimulation}
\alias{kmassessmentsimulation}
\title{Simulate assessments for a set of response patterns}
\usage{
kmassessmentsimulation(
  respdata,
  ks,
  questioning,
  update,
  beta,
  eta,
  zeta0,
  zeta1,
  threshold
)
}
\arguments{
\item{respdata}{Data matrix}

\item{ks}{Knowledge structure}

\item{questioning}{Question rule}

\item{update}{Updating rule}

\item{beta}{Careless error probability}

\item{eta}{Lucky guess probability}

\item{zeta0}{Update parameter for wrong responses}

\item{zeta1}{Update parameter for correct responses}

\item{threshold}{Stopping criterion}
}
\value{
Assessment data as data frame
}
\description{
\code{kmassessmentsimulation} does a probabilistic knowledge assessment
for each response pattern in a data matrix and stores information about
the assessment.
}
\details{
\code{kmassessmentsimulation} applies the \code{kmsassess} function.
}
\examples{
kmassessmentsimulation(
  xpl$data,
  xpl$space,
  "halfsplit",
  "multiplicative",
  NULL,
  NULL,
  5,
  5,
  0.55
)

}
\seealso{
Other Knowledge assessment: 
\code{\link{kmassess}()},
\code{\link{kmassessbayesian}()},
\code{\link{kmassesshalfsplit}()},
\code{\link{kmassessinformative}()},
\code{\link{kmassessmultiplicative}()},
\code{\link{kmsassess}()}
}
\concept{Knowledge assessment}
