% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/includeMedia.R
\name{includeText}
\alias{includeText}
\title{Insert text into a document.}
\usage{
includeText(path, data = parent.frame(), quiet = TRUE)
}
\arguments{
\item{path}{Path to the child document.}

\item{data}{Environment or list used to knit the child document.}

\item{quiet}{Passed to \code{\link[knitr:knit]{knitr::knit()}}.}
}
\value{
An R object of class "knit_asis" (defined in the \link[knitr:knitr-package]{knitr} package),
the data of which represents the content of the child document (after
\code{\link[knitr:knit]{knitr::knit()}})
}
\description{
Insert text into a document.
}
\examples{
template <- tempfile()
cat("Hello, `r name`.\n", file = template)
includeText(template, data = list(name = "Alice"))
file.remove(template)

}
