% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_omv.R
\name{replace_omv}
\alias{replace_omv}
\title{Search values in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})}
\usage{
replace_omv(
  dtaInp = NULL,
  fleOut = "",
  rplLst = list(),
  whlTrm = TRUE,
  varInc = c(),
  varExc = c(),
  incNum = TRUE,
  incOrd = TRUE,
  incNom = TRUE,
  incID = TRUE,
  incCmp = TRUE,
  incRcd = TRUE,
  psvAnl = FALSE,
  ...
)
}
\arguments{
\item{dtaInp}{Either a data frame or the name of a jamovi data file to be read (including the path, if required; "FILENAME.omv"; default: NULL)}

\item{fleOut}{Name of the data file to be written (including the path, if required; "FILE_OUT.omv"; default: ""); if empty, the resulting data frame is
returned instead}

\item{rplLst}{A list where each entry is a vector (with length 2) containing the original value and the to-replace-value (default: list())}

\item{whlTrm}{Whether the search term (first entry in the vectors) must be found exactly (TRUE) or whether a partial match is sufficient (FALSE; default:
TRUE)}

\item{varInc}{Names of variables (character vector) to be included in the replacement (default: c())}

\item{varExc}{Names of variables (character vector) to be excluded from the replacement (default: c())}

\item{incNum}{Whether to include continuous variables in the replacement (default: TRUE)}

\item{incOrd}{Whether to include ordinal variables in the replacement (default: TRUE)}

\item{incNom}{Whether to include nominal variables in the replacement (default: TRUE)}

\item{incID}{Whether to include ID variables in the replacement (default: TRUE)}

\item{incCmp}{Whether to include Computed variables in the replacement (default: TRUE)}

\item{incRcd}{Whether to include Recoded variables in the replacement (default: TRUE)}

\item{psvAnl}{Whether analyses that are contained in the input file shall be transferred to the output file (default: FALSE)}

\item{...}{Additional arguments passed on to methods; see Details below}
}
\value{
a data frame (only returned if \code{fleOut} is empty) with the replaced values
}
\description{
Search values in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})
}
\details{
\itemize{
\item \code{rplLst} is a list. Each list entry contains a vector (with length 2), where the first entry is the original value, and the second entry is the value the
original value is to be replaced with.
\item \code{whlTrm} indicates whether partial matches of the original value(s) shall replaced (e.g., for original: 24 and replacement: 34, 241 will be changed into
341).
\item \code{varInc} and \code{varExc} determine which variables are included or excluded from the replacement. If both are given, a warning is issued and \code{varInc} takes
precedence. \code{varInc} makes that only in these variables, the replacement requested by \code{rplLst} is carried out, if \code{varExc} is given, for all variables of
the input data set, except those defined in \code{varExc}, the replacement is carried out.
\item The ellipsis-parameter (\code{...}) can be used to submit arguments / parameters to the function that is used for reading and writing the data. Clicking on the
respective function under “See also”, you can get a more detailed overview over which parameters each of those functions take. The functions are:
\code{read_omv} and \code{write_omv} (for jamovi-files).
}
}
\examples{
\dontrun{
bfi_sample <- jmvReadWrite::bfi_sample
# the gender in the original data file is plural...
table(bfi_sample$gender)
# and shall be converted to singular
rplDF <- jmvReadWrite::replace_omv(dtaInp = bfi_sample,
           rplLst = list(c("Females", "Female"), c("Males", "Male")))
table(rplDF$gender)
# with giving an output file name, the data set is written
nmeOut <- tempfile(fileext = ".omv")
jmvReadWrite::replace_omv(bfi_sample, fleOut = nmeOut,
  rplLst = list(c("Females", "Female"), c("Males", "Male")))
file.exists(nmeOut)
rplDF <- jmvReadWrite::read_omv(nmeOut)
table(rplDF$gender)
unlink(nmeOut)
# it is sensible to check / search for the original values before running replace_omv
jmvReadWrite::search_omv(bfi_sample, 24, whlTrm = TRUE)
rplDF <- jmvReadWrite::replace_omv(bfi_sample, rplLst = list(c(24, NA)))
table(rplDF$age)
}

}
\seealso{
\code{replace_omv} uses \code{\link[=read_omv]{read_omv()}} and \code{\link[=write_omv]{write_omv()}} for reading and writing jamovi-files.
}
