% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{orbi_flag_outliers}
\alias{orbi_flag_outliers}
\title{Flag outlier scans}
\usage{
orbi_flag_outliers(
  dataset,
  agc_fold_cutoff = NA_real_,
  agc_window = c(),
  agc_absolute_cutoff = c(),
  by_block = TRUE
)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{agc_fold_cutoff}{flags scans with a fold cutoff based on the average number of ions in the Orbitrap analyzer. For example, \code{agc_fold_cutoff = 2} flags scans that have more than 2 times, or less than 1/2 times the average. TIC multiplied by injection time serves as an estimate for the number of ions in the Orbitrap.}

\item{agc_window}{flags scans with a critically low or high number of ions in the Orbitrap analyzer. Provide a vector with 2 numbers \code{c(x,y)} flagging the lowest x percent and highest y percent. TIC multiplied by injection time serves as an estimate for the number of ions in the Orbitrap.}

\item{agc_absolute_cutoff}{flags scans with a number of ions in the Orbitrap analyzer outside of an absolute range. Provide a vector with 2 numbers \code{c(x,y)} flagging data below x and above y of the TIC multiplied by injection time (which serves as an estimate for the number of ions in the Orbitrap).}

\item{by_block}{if the \code{dataset} has block and segment definitions, should the outlier flag be evaluated within each block+segment or globally? default is within each block+segment, switch to globally by turning \code{by_block = FALSE}}
}
\value{
same object as provided in \code{dataset} with new columns \code{is_outlier} and \code{outlier_type} (if they don't already exist) that flags outliers identified by the method and provides the type of outlier (e.g. "2 fold agc cutoff"), respectively.
}
\description{
This function flags outliers using one of the different methods provided by the parameters (to use multiple, please call this function several times sequentially).
Note that this function evaluates outliers within each "uidx", "filename", and "injection" (for those of the columns that exist),
and additionally within each "block" and "segment" if \code{by_block = TRUE}.
in addition to any groupings already defined before calling this function using dplyr's \code{group_by()}. It restores the original groupings in the returned datasert.
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <-
  orbi_read_isox(file = fpath) |>
  orbi_simplify_isox() |>
  orbi_flag_outliers(agc_window = c(1,99))

}
