% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_regression_model.R
\name{fit_srm}
\alias{fit_srm}
\title{Sparse regression model}
\usage{
fit_srm(
  x,
  y,
  cross_validation = FALSE,
  seed = 1,
  penalty = "L0",
  regulators_num = ncol(x),
  n_folds = 5,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{The matrix of regulators.}

\item{y}{The vector of target.}

\item{cross_validation}{Whether to use cross-validation.
Default is \code{FALSE}.}

\item{seed}{The random seed for cross-validation.
Default is \code{1}.}

\item{penalty}{The type of regularization, default is \code{"L0"}.
This can take either one of the following choices: \code{"L0"}, \code{"L0L1"}, and \code{"L0L2"}.
For high-dimensional and sparse data, \code{"L0L2"} is more effective.}

\item{regulators_num}{The number of regulators for target.}

\item{n_folds}{The number of folds for cross-validation.
Default is \code{5}.}

\item{verbose}{Whether to print progress messages.
Default is \code{TRUE}.}

\item{...}{Parameters for other methods.}
}
\value{
A list of the sparse regression model.
The list has the three components: model, metrics, and coefficients.
}
\description{
Sparse regression model
}
\examples{
data(example_matrix)
fit_srm(
  x = example_matrix[, -1],
  y = example_matrix[, 1]
)
}
