% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_fup_adjustment.R
\name{apply_fup_adjustment}
\alias{apply_fup_adjustment}
\title{Correct the measured fraction unbound in plasma for lipid binding}
\usage{
apply_fup_adjustment(
  fup,
  fup.correction = NULL,
  Pow = NULL,
  pKa_Donor = NULL,
  pKa_Accept = NULL,
  suppress.messages = FALSE,
  minimum.Funbound.plasma = 1e-04
)
}
\arguments{
\item{fup}{In vitro measured fraction unbound in plasma}

\item{fup.correction}{Estimated correction to account for additional lipid
binding in vivo (Pearce et al., 2017) from \code{\link{calc_fup_correction}}}

\item{Pow}{The octanal:water equilibrium partition coefficient}

\item{pKa_Donor}{A string containing hydrogen donor ionization equilibria, 
concatenated with commas. Can be "NA" if none exist.}

\item{pKa_Accept}{A string containing hydrogen acceptance ionization equilibria, 
concatenated with commas. Can be "NA" if none exist.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{minimum.Funbound.plasma}{\ifelse{html}{\out{f<sub>up</sub>}}{\eqn{f_{up}}}
is not allowed to drop below this value (default is 0.0001).}
}
\value{
Fraction unbound in plasma adjusted to take into account binding
in the in vitro assay
}
\description{
This function uses the lipid binding correction estimated by Pearce
et al. (2017) to decrease the fraction unbound in plasma
(\ifelse{html}{\out{f<sub>up</sub>}}{\eqn{f_{up}}}). This correction
assumes that there is additional in vivo binding to lipid, which
has a greater impact on neutral lipophilic compounds.
}
\references{
\insertRef{kilford2008hepatocellular}{httk} 
\insertRef{wetmore2015incorporating}{httk}
}
\seealso{
\code{\link{calc_fup_correction}}
}
\author{
John Wambaugh
}
\keyword{in-vitro}
