% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneRowhaplotpe2twoRowhaplotype.R
\name{.o2tH}
\alias{.o2tH}
\title{Convert a one-row haplotype to a two-row haplotype}
\usage{
.o2tH(haplotype)
}
\arguments{
\item{haplotype}{A haplotype object:
\itemize{
  \item a matrix with individuals in rows and allele columns in pairs
  (i.e. \code{ncol(haplotype)} must be even).
}}
}
\value{
An integer matrix in a two-row-per-individual format with
\code{2 * nrow(haplotype)} rows and \code{ncol(haplotype) / 2} columns.
Row names are interleaved using the original individual names.
}
\description{
Converts a haplotype matrix where each individual is represented by one row
and alleles are stored in alternating columns (1st allele, 2nd allele, ...)
into a two-row-per-individual representation.
}
\details{
Internally, any allele code of `2` is converted to `0` before conversion.
}
