% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mstate3_exdata}
\alias{mstate3_exdata}
\title{Example data for a reversible 3-state multi-state model}
\format{
A list containing the following elements:
\describe{
\item{transitions}{A data frame containing the times at which patient transitions between health states based
on the \link[mstate:Liver-cirrhosis-data]{prothr} dataset from the \link[mstate:mstate-package]{mstate} package.}
\item{costs}{A list of data frames. The first data frame contains summary medical cost estimates and the
second data frame contains drug cost data.}
\item{utility}{A data frame of summary utility estimates.}
}
}
\usage{
mstate3_exdata
}
\description{
Example multi-state data for parameterizing a continuous time state
transition model. Costs and utility
are also included to facilitate cost-effectiveness analysis.
}
\section{Transitions data}{

The data frame has the following columns:
\describe{
\item{strategy_id}{Treatment strategy identification number.}
\item{patient_id}{Patient identification number.}
\item{age}{Patient age (in years).}
\item{female}{1 if a patient is female; 0 if male.}
\item{from}{Starting state.}
\item{to}{Receiving state.}
\item{trans}{Transition number.}
\item{Tstart}{Starting time.}
\item{Tstop}{Transition time.}
\item{years}{Elapsed years between \code{Tstart} and \code{Tstop}.}
\item{status}{Status variable; 1=transition, 0=censored.}
}
}

\section{Cost data}{

The cost list contains two data frames. The first data frame contains
data on the drug costs associated with each treatment strategy.
\describe{
\item{strategy_id}{The treatment strategy identification number.}
\item{costs}{Annualized drug costs.}
}

The second data frame contains summary data on
medical costs by health state, and contains the following columns:
\describe{
\item{state_id}{The health state identification number.}
\item{mean}{Mean costs.}
\item{se}{Standard error of medical costs.}
}
}

\section{Utility data}{

The data frame has the following columns:
\describe{
\item{state_id}{The health state identification number.}
\item{mean}{Mean utility}
\item{se}{Standard error of utility}
}
}

\keyword{datasets}
