% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mom.R
\name{estimate_nb_mom}
\alias{estimate_nb_mom}
\title{Method of Moments Estimation for Negative Binomial Parameters}
\usage{
estimate_nb_mom(data, group = NULL)
}
\arguments{
\item{data}{A data frame containing the data. Must include columns
\code{events} (number of events) and \code{tte} (total exposure/follow-up time).}

\item{group}{Optional character string specifying the grouping column name
(e.g., "treatment"). If provided, rates are estimated separately for each
group, while a common dispersion parameter is estimated across groups.
If NULL (default), a single rate and dispersion are estimated (blinded case).}
}
\value{
A list containing:
\item{lambda}{Estimated event rate(s). A single numeric value if \code{group} is NULL,
or a named vector if \code{group} is provided.}
\item{dispersion}{Estimated common dispersion parameter (k).}
}
\description{
Estimates the event rate(s) and common dispersion parameter (k) for
negative binomial count data using the method of moments.
This is a robust alternative to Maximum Likelihood Estimation (MLE),
especially when MLE fails to converge or produces boundary estimates.
}
\details{
The method of moments estimator for the dispersion parameter \eqn{k} is derived
by equating the theoretical variance to the observed second central moment,
accounting for varying exposure times.

For a given group with rate \eqn{\lambda}, the expected count for subject \eqn{i}
is \eqn{\mu_i = \lambda t_i}. The variance is \eqn{V_i = \mu_i + k \mu_i^2}.
The estimator is calculated as:
\deqn{\hat{k} = \max\left(0, \frac{\sum (y_i - \hat{\mu}_i)^2 - \sum y_i}{\sum \hat{\mu}_i^2}\right)}
where \eqn{y_i} is the number of events, \eqn{t_i} is the exposure time,
and \eqn{\hat{\mu}_i = \hat{\lambda} t_i} is the estimated expected count.

When multiple groups are present, the numerator and denominator are summed
across all groups to estimate a common \eqn{k}.
}
\examples{
# Blinded estimation (single group)
df <- data.frame(events = c(1, 2, 0, 3), tte = c(1, 1.2, 0.5, 1.5))
estimate_nb_mom(df)

# Unblinded estimation (two groups)
df_group <- df
df_group$group <- c("A", "A", "B", "B")
estimate_nb_mom(df_group, group = "group")
}
