% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_filter.R
\name{gas_filter}
\alias{gas_filter}
\title{Filter GAS Model}
\usage{
gas_filter(
  gas_object = NULL,
  method = "simulated_coefs",
  coef_set = NULL,
  rep_gen = 1000L,
  t_ahead = 0L,
  x_ahead = NULL,
  rep_ahead = 1000L,
  quant = c(0.025, 0.975),
  y = NULL,
  x = NULL,
  distr = NULL,
  param = NULL,
  scaling = "unit",
  regress = "joint",
  p = 1L,
  q = 1L,
  par_static = NULL,
  par_link = NULL,
  par_init = NULL,
  coef_fix_value = NULL,
  coef_fix_other = NULL,
  coef_fix_special = NULL,
  coef_bound_lower = NULL,
  coef_bound_upper = NULL,
  coef_est = NULL,
  coef_vcov = NULL
)
}
\arguments{
\item{gas_object}{An optional GAS estimate, i.e. a list of S3 class \code{gas} returned by function \code{\link[gasmodel:gas]{gas()}}.}

\item{method}{A method used for parameter uncertainty. Supported methods are \code{"given_coefs"} and \code{"simulated_coefs"}.}

\item{coef_set}{A numeric matrix of coefficient sets in rows for \code{method = "given_coefs"}. Can be generated for example by \code{\link[gasmodel:gas_bootstrap]{gas_bootstrap()}}.}

\item{rep_gen}{A number of generated coefficient sets for \code{method = "simulated_coefs"}.}

\item{t_ahead}{A number of observations to forecast.}

\item{x_ahead}{Out-of-sample exogenous variables. For a single variable common for all time-varying parameters, a numeric vector. For multiple variables common for all time-varying parameters, a numeric matrix with observations in rows. For individual variables for each time-varying parameter, a list of numeric vectors or matrices in the above form. The number of observation must be equal to \code{t_ahead}.}

\item{rep_ahead}{A number of simulation repetitions for forecasting when \code{t_ahead > 0}.}

\item{quant}{A numeric vector of probabilities determining quantiles.}

\item{y, x, distr, param, scaling, regress, p, q, par_static, par_link, par_init, coef_fix_value, coef_fix_other, coef_fix_special, coef_bound_lower, coef_bound_upper, coef_est, coef_vcov}{When \code{gas_object} is not supplied, the estimated model can be specified using these individual arguments. See the arguments and value of the \code{\link[gasmodel:gas]{gas()}} function for more details.}
}
\value{
A \code{list} of S3 class \code{gas_filter} with components:
\item{data$y}{The time series.}
\item{data$x}{The exogenous variables.}
\item{data$x_ahead}{The out-of-sample exogenous variables. Only when \code{t_ahead > 0}.}
\item{model$distr}{The conditional distribution.}
\item{model$param}{The parametrization of the conditional distribution.}
\item{model$scaling}{The scaling function.}
\item{model$regress}{The specification of the regression and dynamic equation.}
\item{model$t}{The length of the time series.}
\item{model$t_ahead}{The length of the out-of-sample time series. Only when \code{t_ahead > 0}.}
\item{model$n}{The dimension of the model.}
\item{model$m}{The number of exogenous variables.}
\item{model$p}{The score order.}
\item{model$q}{The autoregressive order.}
\item{model$par_static}{The static parameters.}
\item{model$par_link}{The parameters with the logarithmic/logistic links.}
\item{model$par_init}{The initial values of the time-varying parameters.}
\item{model$coef_fix_value}{The values to which coefficients are fixed.}
\item{model$coef_fix_other}{The multiples of the estimated coefficients, which are added to the fixed coefficients.}
\item{model$coef_fix_special}{The predefined structures of \code{coef_fix_value} and \code{coef_fix_other}.}
\item{model$coef_bound_lower}{The lower bounds on coefficients.}
\item{model$coef_bound_upper}{The upper bounds on coefficients.}
\item{model$coef_set}{The coefficient sets.}
\item{filter$method}{The method used for parameter uncertainty.}
\item{filter$par_tv_mean}{The mean of the time-varying parameters.}
\item{filter$par_tv_sd}{The standard deviation of the time-varying parameters.}
\item{filter$par_tv_quant}{The quantiles of the time-varying parameters.}
\item{filter$score_tv_mean}{The mean of the scores.}
\item{filter$score_tv_sd}{The standard deviation of the scores.}
\item{filter$score_tv_quant}{The quantiles of the scores.}
\item{filter$y_ahead_mean}{The mean of the forecasted time series. Only when \code{t_ahead > 0}.}
\item{filter$y_ahead_sd}{The standard deviation of the forecasted time series. Only when \code{t_ahead > 0}.}
\item{filter$y_ahead_quant}{The quantiles of the forecasted time series. Only when \code{t_ahead > 0}.}
\item{filter$par_tv_ahead_mean}{The mean of the forecasted time-varying parameters. Only when \code{t_ahead > 0}.}
\item{filter$par_tv_ahead_sd}{The standard deviation of the forecasted time-varying parameters. Only when \code{t_ahead > 0}.}
\item{filter$par_tv_ahead_quant}{The quantiles of the forecasted time-varying parameters. Only when \code{t_ahead > 0}.}
\item{filter$score_tv_ahead_mean}{The mean of the forecasted scores. Only when \code{t_ahead > 0}.}
\item{filter$score_tv_ahead_sd}{The standard deviation of the forecasted scores. Only when \code{t_ahead > 0}.}
\item{filter$score_tv_ahead_quant}{The quantiles of the forecasted scores. Only when \code{t_ahead > 0}.}
}
\description{
A function for obtaining filtered time-varying parameters of generalized autoregressive score (GAS) models of Creal et al. (2013) and Harvey (2013).
It captures parameter uncertainty and can also be used for forecasting.
Method \code{"simulated_coefs"} computes a path of time-varying parameters for each simulated coefficient set under assumption of asymptotic normality with given variance-covariance matrix (see Blasques et al., 2016).
Method \code{"given_coefs"} computes a path of time-varying parameters for each supplied coefficient set.
Instead of supplying arguments about the model, the function can be applied to the \code{gas} object obtained by the \code{\link[gasmodel:gas]{gas()}} function.
}
\note{
Supported generic functions for S3 class \code{gas_filter} include \code{\link[base:summary]{summary()}} ans \code{\link[base:plot]{plot()}}.
}
\examples{
\donttest{# Load the Daily Toilet Paper Sales dataset
data("toilet_paper_sales")
y <- toilet_paper_sales$quantity
x <- as.matrix(toilet_paper_sales[3:9])

# Estimate GAS model based on the negative binomial distribution
est_negbin <- gas(y = y, x = x, distr = "negbin", regress = "sep")
est_negbin

# Filter the time-varying parameters by the "simulated_coefs" method
flt_negbin <- gas_filter(est_negbin, rep_gen = 100)
flt_negbin

# Plot the time-varying parameters with confidence bands
plot(flt_negbin)}

}
\references{
Blasques, F., Koopman, S. J., Łasak, K., and Lucas, A. (2016). In-Sample Confidence Bands and Out-of-Sample Forecast Bands for Time-Varying Parameters in Observation-Driven Models. \emph{International Journal of Forecasting}, \strong{32}(3), 875–887. \doi{10.1016/j.ijforecast.2015.11.018}.

Creal, D., Koopman, S. J., and Lucas, A. (2013). Generalized Autoregressive Score Models with Applications. \emph{Journal of Applied Econometrics}, \strong{28}(5), 777–795. \doi{10.1002/jae.1279}.

Harvey, A. C. (2013). \emph{Dynamic Models for Volatility and Heavy Tails: With Applications to Financial and Economic Time Series}. Cambridge University Press. \doi{10.1017/cbo9781139540933}.
}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
}
