% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{vis.path.along.verts}
\alias{vis.path.along.verts}
\title{Draw a 3D line from vertex to vertex}
\usage{
vis.path.along.verts(
  surface_vertices,
  path_vertex_indices = NULL,
  do_vis = TRUE,
  color = "#FF0000",
  no_material = FALSE
)
}
\arguments{
\item{surface_vertices}{float matrix of size (n, 3), the surface vertex coordinates, as returned as part of \code{\link[fsbrain]{subject.surface}} or \code{\link[freesurferformats]{read.fs.surface}}, in the member "vertices". Can also be a \code{freesurferformats::fs.surface} or \code{rgl::tmesh3d} instance, in which case the coordinates are extracted automatically.}

\item{path_vertex_indices}{vector of vertex indices, the path. You will need to have it computed already. (This function does **not** compute geodesic paths, see \code{\link[fsbrain]{geodesic.path}} for that. You can use it to visualize such a path though.) If omitted, the vertex coordinates will be traversed in their given order to create the path.}

\item{do_vis}{logical, whether to actually draw the path.}

\item{color}{a color string, like '#FF0000' to color the path.}

\item{no_material}{logical, whether to use set the custom rendering material properties for path visualization using \code{rgl::material3d} before plotting. If you set this to FALSE, no material will be set and you should set it yourself before calling this function, otherwise the looks of the path are undefined (dependent on the default material on your system, or the last material call). Setting this to TRUE also means that the 'color' argument is ignored of course, as the color is part of the material.}
}
\value{
n x 3 matrix, the coordinates of the path, with appropriate ones duplicated for rgl pair-wise segments3d rendering.
}
\description{
To get a nice path along the surface, pass the vertex indices along a geodesic path. Note: You can first open an interactive brain view (`views='si'`) with a vis* function like \code{\link[fsbrain]{vis.subject.morph.native}}, then run this function to draw into the active plot.
}
\examples{
\dontrun{
  sjd = fsaverage.path(TRUE);
  surface = subject.surface(sjd, 'fsaverage3',
    surface = "white", hemi = "lh");
  p = geodesic.path(surface, 5, c(10, 20));
  vis.subject.morph.native(sjd, 'fsaverage3', views='si');
  vis.path.along.verts(surface$vertices, p[[1]]);
}

}
\seealso{
\code{\link[fsbrain]{vis.paths}} if you need to draw many paths, \code{\link[fsbrain]{geodesic.path}} to compute a geodesic path.

Other surface mesh functions: 
\code{\link{face.edges}()},
\code{\link{label.border}()},
\code{\link{mesh.vertex.included.faces}()},
\code{\link{mesh.vertex.neighbors}()},
\code{\link{subject.surface}()}
}
\concept{surface mesh functions}
