% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{vertex.coords}
\alias{vertex.coords}
\title{Return coordinates for vertices, supporting entire brain via hemilist.}
\usage{
vertex.coords(surface, vertices)
}
\arguments{
\item{surface}{an fs.surface instance, see \code{\link[fsbrain]{subject.surface}} function. Can also be a hemilist of surfaces, in which case the vertices must be indices over both meshes (in range \code{1..(nv(lh)+nv(rh))}). If a hemilist, both entries must be surfaces (non-NULL).}

\item{vertices}{vector of positive integers, the vertex indices. Values which are outside of the valid indices for the surface will be silently ignored, making it easier to work with the two hemispheres.}
}
\value{
double nx3 matrix of vertex coordinates.
}
\description{
Return coordinates for vertices, supporting entire brain via hemilist.
}
\seealso{
Other 3d utility functions: 
\code{\link{highlight.points.spheres}()},
\code{\link{highlight.vertices.spheres}()}
}
\concept{3d utility functions}
