% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_create.R
\name{project_create}
\alias{project_create}
\title{Create a new Framework project (internal)}
\usage{
project_create(
  name,
  location,
  type = "project",
  author = list(name = "", email = "", affiliation = ""),
  packages = list(use_renv = FALSE, default_packages = list()),
  directories = list(),
  extra_directories = list(),
  ai = list(enabled = FALSE, assistants = c(), canonical_content = ""),
  git = list(use_git = TRUE, hooks = list(), gitignore_content = ""),
  scaffold = list(seed_on_scaffold = FALSE, seed = "", set_theme_on_scaffold = TRUE,
    ggplot_theme = "theme_minimal"),
  connections = NULL,
  env = NULL,
  quarto = NULL,
  render_dirs = NULL
)
}
\arguments{
\item{name}{Project name (used for project title)}

\item{location}{Full path to the project directory (will be created)}

\item{type}{Project type: "project", "project_sensitive", "course", "presentation"}

\item{author}{List with name, email, affiliation}

\item{packages}{List with use_renv (logical) and default_packages (list of package configs)}

\item{directories}{Named list of directory paths (notebooks, scripts, functions, etc.)}

\item{extra_directories}{List of additional custom directories}

\item{ai}{List with enabled, assistants, canonical_content}

\item{git}{List with use_git, hooks, gitignore_content}

\item{scaffold}{List with seed_on_scaffold, seed, set_theme_on_scaffold, ggplot_theme, ide, positron}

\item{quarto}{List with html and revealjs format configurations for Quarto}

\item{render_dirs}{Named list of render directory paths for Quarto outputs}
}
\value{
List with success status, project path, and project ID
}
\description{
Low-level function that creates a complete Framework project. This is called
by the GUI and by user-facing functions like \code{\link[=new]{new()}} and \code{\link[=new_project]{new_project()}}.
Users should typically use \code{\link[=new]{new()}} instead.
}
\keyword{internal}
