% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_write.R
\name{data_save}
\alias{data_save}
\title{Save data using dot notation or file path}
\usage{
data_save(
  data,
  path,
  type = NULL,
  delimiter = "comma",
  locked = TRUE,
  force = FALSE
)
}
\arguments{
\item{data}{Data frame to save}

\item{path}{Either:
\itemize{
\item Dot notation: \code{inputs.raw.filename} resolves to inputs/raw/filename.rds
\item Direct path: "inputs/raw/filename.csv" uses path as-is
}

Dot notation uses your configured directories
(e.g., \code{inputs.raw}, \code{inputs.intermediate}, \code{outputs.private}).}

\item{type}{Type of data file ("csv" or "rds"). Auto-detected from extension if path includes one.}

\item{delimiter}{Delimiter for CSV files ("comma", "tab", "semicolon", "space")}

\item{locked}{Whether the file should be locked after saving}

\item{force}{If TRUE, creates missing directories. If FALSE (default), errors if directory doesn't exist.}
}
\value{
Invisibly returns the saved data.
}
\description{
Save data using dot notation or file path
}
