% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/hrf.R, R/reg-methods.R
\name{nbasis}
\alias{nbasis}
\alias{nbasis.HRF}
\alias{nbasis.Reg}
\title{Number of basis functions}
\usage{
nbasis(x, ...)

\method{nbasis}{HRF}(x, ...)

\method{nbasis}{Reg}(x, ...)
}
\arguments{
\item{x}{Object containing HRF or regressor information.}

\item{...}{Additional arguments passed to methods.}
}
\value{
Integer scalar giving the number of basis functions.
}
\description{
Return the number of basis functions represented by an object.
}
\details{
This information is typically used when constructing penalty matrices
or understanding the complexity of an HRF model or regressor.
}
\examples{
# Number of basis functions for different HRF types
nbasis(HRF_SPMG1)   # 1 basis function
nbasis(HRF_SPMG3)   # 3 basis functions (canonical + 2 derivatives)
nbasis(HRF_BSPLINE) # 5 basis functions (default)

# For a regressor
reg <- regressor(onsets = c(10, 30, 50), hrf = HRF_SPMG3)
nbasis(reg)  # 3 (inherits from the HRF)
}
