% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{as_hrf}
\alias{as_hrf}
\title{Turn any function into an HRF object}
\usage{
as_hrf(
  f,
  name = deparse(substitute(f)),
  nbasis = 1L,
  span = 24,
  params = list()
)
}
\arguments{
\item{f}{The function to be turned into an HRF object. It must accept a single argument `t` (time).}

\item{name}{The name for the HRF object. Defaults to the deparsed name of `f`.}

\item{nbasis}{The number of basis functions represented by `f`. Must be \code{>= 1}. Defaults to 1L.}

\item{span}{The nominal time span (duration in seconds) of the HRF. Must be positive. Defaults to 24.}

\item{params}{A named list of parameters associated with the HRF function `f`. Defaults to an empty list.}
}
\value{
A new HRF object.
}
\description{
This is the core constructor for creating HRF objects in the refactored system.
It takes a function `f(t)` and attaches standard HRF attributes.
}
\examples{
# Create a custom HRF from a function
custom_hrf <- as_hrf(function(t) exp(-t/5), 
                     name = "exponential", 
                     span = 20)
evaluate(custom_hrf, seq(0, 10, by = 1))
}
\keyword{internal}
