% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{mae}
\alias{mae}
\title{Calculate Mean Absolute Error (MAE)}
\usage{
mae(y, mu)
}
\arguments{
\item{y}{Numeric vector representing the observed values.}

\item{mu}{Numeric vector representing the predicted values.}
}
\value{
Numeric value representing the MAE.
}
\description{
This function calculates the Mean Absolute Error (MAE) between observed and
predicted values.
}
\details{
The MAE is calculated using the formula:
\deqn{MAE = \frac{1}{n} \sum_{i=1}^{n} |y_i - \mu_i|}
Where \eqn{y} is the vector of observed values and \eqn{\mu} is the vector of
predicted values.
}
\examples{
y <- c(1, 2, 3)
mu <- c(1.1, 1.9, 3.2)
mae(y, mu)

}
