% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psichel.R
\name{SichelDistribution}
\alias{SichelDistribution}
\alias{dsichel}
\alias{psichel}
\alias{qsichel}
\alias{rsichel}
\title{Sichel Distribution}
\usage{
dsichel(x, mu = 1, sigma = 1, gamma = 1, log = FALSE)

psichel(q, mu = 1, sigma = 1, gamma = 1, lower.tail = TRUE, log.p = FALSE)

qsichel(p, mu = 1, sigma = 1, gamma = 1, lower.tail = TRUE, log.p = FALSE)

rsichel(n, mu = 1, sigma = 1, gamma = 1)
}
\arguments{
\item{x}{numeric value or vector of non-negative integer values.}

\item{mu}{numeric; mean of the distribution (mu > 0).}

\item{sigma}{numeric; scale parameter (sigma > 0).}

\item{gamma}{numeric; shape parameter (can be any real number).}

\item{log, log.p}{logical; if TRUE, probabilities are given as log(p).}

\item{q}{quantile or vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities are P[X <= x].}

\item{p}{probability or vector of probabilities.}

\item{n}{number of random values to generate.}
}
\value{
dsichel gives the density, psichel gives the distribution 
 function, qsichel gives the quantile function, and rsichel 
 generates random  deviates.

 The length of the result is determined by n for rsichel, and is the 
 maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function, and random generation
for the Sichel distribution.
}
\details{
The Sichel distribution is a three-parameter discrete distribution that
generalizes the Poisson-inverse Gaussian distribution. It is useful for
modeling overdispersed count data.

The PMF is:
\deqn{f(y|\mu, \sigma, \gamma) = 
\frac{(\mu/c)^y K_{y+\gamma}(\alpha)}{K_\gamma(1/\sigma) y! 
(\alpha\sigma)^{y+\gamma}}}
}
\examples{
# Basic usage
dsichel(0:10, mu = 5, sigma = 1, gamma = -0.5)

# Log-probabilities for numerical stability
dsichel(0:10, mu = 5, sigma = 1, gamma = -0.5, log = TRUE)

# CDF
psichel(5, mu = 5, sigma = 1, gamma = -0.5)

}
\references{
Rigby, R. A., Stasinopoulos, D. M., & Akantziliotou, C. (2008).
A framework for modelling overdispersed count data, including the
Poisson-shifted generalized inverse Gaussian distribution.
Computational Statistics & Data Analysis, 53(2), 381-393.
}
