% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_env.R
\name{stepwise}
\alias{stepwise}
\alias{sw}
\alias{csw}
\alias{sw0}
\alias{csw0}
\alias{mvsw}
\title{Stepwise estimation tools}
\usage{
sw(...)

csw(...)

sw0(...)

csw0(...)

mvsw(...)
}
\arguments{
\item{...}{Represents formula variables to be added in a stepwise fashion to an estimation.}
}
\description{
Functions to perform stepwise estimations in \code{fixest} models.
}
\details{
To include multiple independent variables, you need to use the stepwise functions.
There are 5 stepwise functions: \code{sw}, \code{sw0}, \code{csw}, \code{csw0} and \code{mvsw}. Let's explain that.

Assume you have the following formula: \code{fml = y ~ x1 + sw(x2, x3)}. The stepwise
function \code{sw} will estimate the following two models: \code{y ~ x1 + x2} and \code{y ~ x1 + x3}.
That is, each element in \code{sw()} is sequentially, and separately, added to the formula.
Would have you used \code{sw0} in lieu of \code{sw}, then the model \code{y ~ x1} would also have
been estimated. The \code{0} in the name implies that the model without any stepwise
element will also be estimated.

Finally, the prefix \code{c} means cumulative: each stepwise element is added to the next.
That is, \code{fml = y ~ x1 + csw(x2, x3)} would lead to the following models \code{y ~ x1 + x2}
and \code{y ~ x1 + x2 + x3}. The \code{0} has the same meaning and would also lead to the model
without the stepwise elements to be estimated: in other words,
\code{fml = y ~ x1 + csw0(x2, x3)} leads to the following three models: \code{y ~ x1},
\code{y ~ x1 + x2} and \code{y ~ x1 + x2 + x3}.

The last stepwise function, \code{mvsw}, refers to 'multiverse' stepwise. It will estimate
as many models as there are unique combinations of stepwise variables. For example
\code{fml = y ~ x1 + mvsw(x2, x3)} will estimate \code{y ~ x1}, \code{y ~ x1 + x2}, \code{y ~ x1 + x3},
\code{y ~ x1 + x2 + x3}. Beware that the number of estimations grows pretty fast (\code{2^n},
with \code{n} the number of stewise variables)!
}
\examples{

base = setNames(iris, c("y", "x1", "x2", "x3", "species"))

# Regular stepwise
feols(y ~ sw(x1, x2, x3), base)

# Cumulative stepwise
feols(y ~ csw(x1, x2, x3), base)

# Using the 0
feols(y ~ x1 + x2 + sw0(x3), base)

# Multiverse stepwise
feols(y ~ x1 + mvsw(x2, x3), base)

}
