% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_flag-env_var.R
\name{is_enabled.env_var_feature_flag}
\alias{is_enabled.env_var_feature_flag}
\title{Checks if the given environment variable feature flag is enabled}
\usage{
\method{is_enabled}{env_var_feature_flag}(feature_flag)
}
\arguments{
\item{feature_flag}{Flag to be checked whether it is enabled}
}
\value{
TRUE if the environment variable is set to 'true'
}
\description{
Checks if the given environment variable feature flag is enabled
}
\examples{
{
  flag <- create_env_var_feature_flag("FEATURE_X")

  withr::with_envvar(new = list(FEATURE_X = "true"), {
    is_enabled(flag) # Returns TRUE
  })

  is_enabled(flag) # Returns FALSE by default
}
}
