% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_trend_season.R
\name{ts_trend_season}
\alias{ts_trend_season}
\alias{ts_ts}
\title{Trend and Season Model}
\usage{
ts_trend_season(ts, trend = NULL, season = NULL)

ts_ts(ts, trend = NULL, season = NULL)
}
\arguments{
\item{ts}{\code{ts_data} object}

\item{trend}{numeric or logical: if \code{trend} is TRUE then a linear trend will be estimated, otherwise an exponential trend. If \code{trend} is numeric this is considered as trend value}

\item{season}{numeric or logical}
}
\value{
Returns an extended \code{ts_data} object with the following list of elements:
\itemize{
\item \code{t} the time points
\item \code{s} the season for the time points
\item \code{xt} the time series values
\item \code{trend} the fitted trend values
\item \code{trend.coeff} the trend coefficients
\item \code{trend.linear} the trend type, if \code{NA} then it is unknown
\item \code{season} the fitted season values
\item \code{season.t} the fitted season values for the time series
\item \code{trend.season} the fitted values for trend and season
\item \code{trend.linear} the trend type, if \code{NA} then it is unknown
\item \code{var} the variance of the residuals
\item \code{r.square} the \eqn{R^2} of the final model
}
}
\description{
Estimate a trend and season model from a \code{ts_data} object.
}
\examples{
ts <- ts_data(12, trend.coeff= c(sample(0:10, 1), sample(1+(1:10)/20, 1)))
ts_trend_season(ts)
}
