% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dscore.R
\name{dscore}
\alias{dscore}
\title{Calculate discrepancy score}
\usage{
dscore(data, group_var, variables)
}
\arguments{
\item{data}{A dataframe containing the data to be analyzed.}

\item{group_var}{A character string specifying the column name used for grouping the data.}

\item{variables}{A character vector of column names in `data` for which the mean number of
unique values minus one is calculated.}
}
\value{
A tibble with each specified variable showing the mean of (unique values - 1)
for each group. The data is grouped by the `group_var` and returns the results in a wide format,
where each variable is prefixed with "dscore_" to indicate the calculation.
}
\description{
This function computes the mean number of unique values minus one for each specified variable
within each group specified by the group_var. It is designed to provide insights into the
variability of each variable while adjusting for the minimum possible unique count.
}
\examples{
df <- data.frame(
  group = c("A", "A", "B", "B", "B"),
  age = c(25, 25, 30, 35, 30),
  gender = c("Male", "Male", "Female", "Female", "Female"),
  income = c(50000, 50000, 60000, 65000, 60000)
)
result <- dscore(df, "group", c("age", "gender", "income"))
print(result)
}
