% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_tbl.R
\name{parameter_tbl}
\alias{parameter_tbl}
\title{Table of epidemiological distributions}
\usage{
parameter_tbl(
  multi_epiparameter,
  disease = "all",
  pathogen = "all",
  epi_name = "all"
)
}
\arguments{
\item{multi_epiparameter}{Either an \verb{<epiparameter>} object or a list of
\verb{<epiparameter>} objects.}

\item{disease}{A \code{character} string with name of the infectious disease.}

\item{pathogen}{A \code{character} string with the name of the causative agent of
disease, or \code{NA} if not known.}

\item{epi_name}{A \code{character} string with the name of the
epidemiological parameter type.}
}
\value{
A \verb{<parameter_tbl>} object which is a subclass of \verb{<data.frame>}.
}
\description{
This function subsets the epidemiological parameter library to
return only the chosen epidemiological distribution. The results are
returned as a data frame containing the disease, epidemiological
distribution, probability distribution, author of the study, and the year
of publication.
}
\examples{
epiparameter_list <- epiparameter_db(disease = "COVID-19")
parameter_tbl(multi_epiparameter = epiparameter_list)

# example filtering an existing list to incubation periods
epiparameter_list <- epiparameter_db(disease = "COVID-19")
parameter_tbl(
  multi_epiparameter = epiparameter_list,
  epi_name = "incubation period"
)
}
\author{
Joshua W. Lambert, Adam Kucharski
}
