% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{is_parameterised}
\alias{is_parameterised}
\alias{is_parameterized}
\alias{is_parameterised.epiparameter}
\alias{is_parameterised.multi_epiparameter}
\title{Check if \verb{<epiparameter>} or list of \verb{<epiparameter>} objects contains a
distribution and distribution parameters}
\usage{
is_parameterised(x, ...)

is_parameterized(x, ...)

\method{is_parameterised}{epiparameter}(x, ...)

\method{is_parameterised}{multi_epiparameter}(x, ...)
}
\arguments{
\item{x}{An \verb{<epiparameter>} or list of \verb{<epiparameter>} objects.}

\item{...}{\link{dots} Extra arguments to be passed to the method.}
}
\value{
A single boolean \code{logical} for \verb{<epiparameter>} or vector of
\code{logical}s equal in length to the list of \verb{<epiparameter>} objects input.
If the \verb{<epiparameter>} object is missing either a probability distribution
or parameters for the probability distribution returns \code{FALSE}, otherwise it
returns \code{TRUE}.
}
\description{
Check if \verb{<epiparameter>} or list of \verb{<epiparameter>} objects contains a
distribution and distribution parameters
}
\examples{
# parameterised <epiparameter>
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation",
  prob_distribution = create_prob_distribution(
    prob_distribution = "gamma",
    prob_distribution_params = c(shape = 1, scale = 1)
  )
)
is_parameterised(ep)

# unparameterised <epiparameter>
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation"
)
is_parameterised(ep)

# list of <epiparameter>
db <- epiparameter_db()
is_parameterised(db)
}
